﻿Imports System.Windows.Threading

Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Private center As Point
    Private radius As Double
    Private numSides As Integer = 2


    Public Sub New()
        InitializeComponent()
    End Sub


    Private Sub OnLoaded(ByVal sender As Object, ByVal args As RoutedEventArgs) Handles Me.Loaded
        center = New Point(ContentPanel.ActualWidth / 2 - 1, ContentPanel.ActualHeight / 2 - 1)
        radius = Math.Min(center.X, center.Y)

        polygon.Points.Add(New Point(center.X, center.Y - radius))
        polygon.Points.Add(New Point(center.X, center.Y + radius))

        Dim tmr As New DispatcherTimer()
        tmr.Interval = TimeSpan.FromSeconds(1)
        AddHandler tmr.Tick, AddressOf OnTimerTick
        tmr.Start()
    End Sub


    Private Sub OnTimerTick(ByVal sender As Object, ByVal args As EventArgs)
        numSides += 1

        For vertex = 1 To numSides - 1
            Dim radians = vertex * 2 * Math.PI / numSides
            Dim x = center.X + radius * Math.Sin(radians)
            Dim y = center.Y - radius * Math.Cos(radians)
            Dim point As New Point(x, y)

            If vertex < numSides - 1 Then
                polygon.Points(vertex) = point
            Else
                polygon.Points.Add(point)
            End If
        Next vertex

        PageTitle.Text = "" & numSides & " sides"
    End Sub
End Class

